/**
 * @name		Floating Module CK
 * @package		mod_floatingmoduleck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 * @version		1.1.11
 */

(function($) {
	$.fn.FloatingModuleCK = function(options) {
		var defaults = {
			time: 200,
			zIndex: '1000',
			minResolution: '640'
		};

		var opts = $.extend(defaults, options);
		var mods = this;
		var $window = $(window);
		// check the resolution to disable the floating
		var doFloating = true;

		mods.each(function(options) {
			var mod = $(this);
			if (mod.attr('data-float') == '1') return;
			mod.attr('data-float', '1');
			mod.data('isfloatingckbottom', false);
			if (mod.attr('data-method') == 'onscroll') {
				floatModule(mod);
				$window.scroll(function() { floatModule(mod); });
				$window.resize(function() { resizeModule(mod); });
			}
			if (mod.attr('data-method') == 'always') {
				$(document.body).prepend(mod);
				mod.css({position: 'absolute', zIndex: opts.zIndex, top: parseInt(mod.attr('data-y')), width: mod.attr('data-w'), backgroundColor: mod.attr('data-bg')}).addClass(mod.attr('data-css'));
				switch (mod.attr('data-pos')) {
					case 'right':
						mod.css({right : parseInt(mod.attr('data-x'))}).css('left', 'auto');
					break;
					case 'bottom':
						mod.css({bottom : parseInt(mod.attr('data-y'))}).css('top', 'auto').css('left', 'auto').css('right',  parseInt(mod.attr('data-x')));
					break;
					case 'left':
					default:
						mod.css({left : parseInt(mod.attr('data-x'))}).css('right', 'auto');
					break;
				}
				fixedModule(mod);
				$window.scroll(function() { fixedModule(mod); });
				$window.on('resize load', function() { checkDofloating(); if(doFloating) {mod.css('display', 'block');} else {mod.css('display', 'none');} });
			}
		});

		function floatModule(mod) {
			checkDofloating();
			var winY = $window.scrollTop();
			if(!mod.data('isfloatingck')) {
				mod.data('floatingckTop', mod.offset().top);
				mod.data('floatingckLeft', mod.offset().left);
				mod.data('floatingckWidth', mod.width());
				mod.data('floatingckHeight', mod.height());
				mod.data('floatingckIniW',(mod[0].style.width ? mod[0].style.width : ''));
				mod.data('floatingckIniH',(mod[0].style.height ? mod[0].style.height : ''));
			}
			modTop = mod.data('floatingckTop');

			// float the module
			var bottomlimit = mod.attr('data-bottomlimit') && $(mod.attr('data-bottomlimit')).length ? $(mod.attr('data-bottomlimit')).offset().top : 0;
			var modTop2 = mod.offset().top;
			var modBottom = modTop2 + mod.height();
			var topvalue = bottomlimit - (winY + mod.height());

			if (mod.attr('data-bottomlimit') && $(mod.attr('data-bottomlimit')).length && modBottom >= bottomlimit && mod.data('isfloatingckbottom') == false) {
				mod.css({position: 'fixed', top: parseFloat(topvalue) + parseFloat(mod.attr('data-bottomoffset')) +'px'}).data('isfloatingckbottom', true);
			} else if (mod.data('isfloatingckbottom') == true) {
				mod.css({position: 'fixed', top: parseFloat(topvalue) + parseFloat(mod.attr('data-bottomoffset')) +'px'});
				if (mod.position().top >= parseInt(mod.attr('data-offsety'))) {
					mod.data('isfloatingckbottom', false).css('top' , parseInt(mod.attr('data-offsety')));
				}
			} else if (modTop < (winY - parseInt(mod.attr('data-offsety')) + parseInt(mod.attr('data-y'))) && !mod.data('isfloatingck') && doFloating) {
				mod.after('<div id="'+mod.attr('id')+'tmp"></div>')
				var modtmp = $('#'+mod.attr('id')+'tmp');
				modtmp
					.css('visibility', 'hidden')
					.height(mod.outerHeight());
				mod.css({position: 'fixed', zIndex: opts.zIndex, marginTop: -parseInt(mod.attr('data-offsety'))+'px',top: parseInt(mod.attr('data-y'))+'px', left: 'auto', width: mod.data('floatingckWidth'), backgroundColor: mod.attr('data-bg')}).data('isfloatingck', true).addClass('isfloatingck').addClass(mod.attr('data-css'));
				mod.attr('data-offset', modTop);
				mod.animate({marginTop: 0}, parseInt(opts.time));
			// else the module is not in the scope, don't float
			} else if (modTop >= winY && mod.data('isfloatingck') || (!doFloating && $('#'+mod.attr('id')+'tmp').length)) {
				var modtmp = $('#'+mod.attr('id')+'tmp');
				mod.data('floatingckTop', modtmp.offset().top);
				mod.data('floatingckLeft', modtmp.offset().left);
				mod.css({position: '', marginTop: '', backgroundColor: '', top: ''}).data('isfloatingck', false).removeClass('isfloatingck').removeClass(mod.attr('data-css'));
				mod.width(mod.data('floatingckIniW')).height(mod.data('floatingckIniH'));
				modtmp.remove();
			}
		}

		function resizeModule(mod) {
			if (!mod.data('isfloatingck')) return;
			var modtmp = $('#'+mod.attr('id')+'tmp');
			mod.data('floatingckTop', modtmp.offset().top);
			mod.data('floatingckLeft', modtmp.offset().left);
			floatModule(mod);
			if ($('#'+mod.attr('id')+'tmp').length) {
				mod.width(modtmp.width());
				modtmp.height(mod.height());
			}
		}

		function fixedModule(mod) {
			var winY = $window.scrollTop();
			var modTop = mod.offset().top;
			switch (mod.attr('data-pos')) {
				case 'bottom':
					mod.css({position: 'fixed', bottom : parseInt(mod.attr('data-y')), top: 'auto', left: 'auto', right:  parseInt(mod.attr('data-x'))});
				break;
				case 'right':
				case 'left':
				default:
					mod.animate({top: winY + parseInt(mod.attr('data-y'))}, parseInt(opts.time)/10);
				break;
			}
			
		}

		function checkDofloating() {
			if ($window.width() <= opts.minResolution) {
				doFloating = false;
			} else {
				doFloating = true;
			}
		}
	}
})(jQuery);